/*****************************************************************************
-  \file : iap2_parameter_free.c
-  \version : $Id: iap2_parameter_free.c, v Exp $
-  \release : $Name:$
-  Contains the source code implementation of freeing the memory allocated for the parameters while parsing
-  \component :
-  \author : Konrad Gerhards/ADITG/ kgerhards@de.adit-jv.com
-  \copyright (c) 2010 - 2016 Advanced Driver Information Technology.
-  This code is developed by Advanced Driver Information Technology.
-  Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
-  All rights reserved.
-  CAUTION: CODES IN THIS FILE ARE AUTOMATCALLY GENERATED BY ENTERPRISE ARCHITECHT,
-           DO NOT CHANGE THE CODE MANUALLY
*****************************************************************************/

#include "iap2_parameter_free.h"
#include "iap2_dlt_log.h"
#include "iap2_utility.h"

void iAP2FreeiAP2AccessoryAuthenticationSerialNumberParameter(iAP2AccessoryAuthenticationSerialNumberParameter* theiAP2AccessoryAuthenticationSerialNumberParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2AccessoryAuthenticationSerialNumberParameter->iAP2AuthenticationSerialNumber,
                        &theiAP2AccessoryAuthenticationSerialNumberParameter->iAP2AuthenticationSerialNumber_count,
                        (S8*)"theiAP2AccessoryAuthenticationSerialNumberParameter->iAP2AuthenticationSerialNumber",
                        iAP2_blob);
}

void iAP2FreeiAP2AuthenticationCertificateParameter(iAP2AuthenticationCertificateParameter* theiAP2AuthenticationCertificateParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2AuthenticationCertificateParameter->iAP2AuthenticationCertificate,
                        &theiAP2AuthenticationCertificateParameter->iAP2AuthenticationCertificate_count,
                        (S8*)"theiAP2AuthenticationCertificateParameter->iAP2AuthenticationCertificate",
                        iAP2_blob);
}

void iAP2FreeiAP2AuthenticationResponseParameter(iAP2AuthenticationResponseParameter* theiAP2AuthenticationResponseParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2AuthenticationResponseParameter->iAP2AuthenticationResponse,
                        &theiAP2AuthenticationResponseParameter->iAP2AuthenticationResponse_count,
                        (S8*)"theiAP2AuthenticationResponseParameter->iAP2AuthenticationResponse",
                        iAP2_blob);
}

void iAP2FreeiAP2IdentificationInformationParameter(iAP2IdentificationInformationParameter* theiAP2IdentificationInformationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2AccessoryFirmwareVersion,
                        &theiAP2IdentificationInformationParameter->iAP2AccessoryFirmwareVersion_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2AccessoryFirmwareVersion",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2AccessoryHardwareVersion,
                        &theiAP2IdentificationInformationParameter->iAP2AccessoryHardwareVersion_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2AccessoryHardwareVersion",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2AccessoryManufacturer,
                        &theiAP2IdentificationInformationParameter->iAP2AccessoryManufacturer_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2AccessoryManufacturer",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2AccessoryModelIdentifier,
                        &theiAP2IdentificationInformationParameter->iAP2AccessoryModelIdentifier_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2AccessoryModelIdentifier",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2AccessoryName,
                        &theiAP2IdentificationInformationParameter->iAP2AccessoryName_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2AccessoryName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2AccessorySerialNumber,
                        &theiAP2IdentificationInformationParameter->iAP2AccessorySerialNumber_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2AccessorySerialNumber",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2AppMatchTeamID,
                        &theiAP2IdentificationInformationParameter->iAP2AppMatchTeamID_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2AppMatchTeamID",
                        iAP2_utf8);
    if(theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent_count;count++)
        {
            iAP2FreeiAP2BluetoothHIDComponent(&theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent);
        theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2BluetoothHIDComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent_count;count++)
        {
            iAP2FreeiAP2BluetoothTransportComponent(&theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent);
        theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2BluetoothTransportComponent_count = 0;
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2CurrentLanguage,
                        &theiAP2IdentificationInformationParameter->iAP2CurrentLanguage_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2CurrentLanguage",
                        iAP2_utf8);
    if(theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol_count;count++)
        {
            iAP2FreeiAP2ExternalAccessoryProtocol(&theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol);
        theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2ExternalAccessoryProtocol_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent_count;count++)
        {
            iAP2FreeiAP2iAP2HIDComponent(&theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent);
        theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2iAP2HIDComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent_count;count++)
        {
            iAP2FreeiAP2LocationInformationComponent(&theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent);
        theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2LocationInformationComponent_count = 0;
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2MaximumCurrentDrawnFromDevice,
                        &theiAP2IdentificationInformationParameter->iAP2MaximumCurrentDrawnFromDevice_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2MaximumCurrentDrawnFromDevice",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2MessagesRecievedfromDevice,
                        &theiAP2IdentificationInformationParameter->iAP2MessagesRecievedfromDevice_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2MessagesRecievedfromDevice",
                        iAP2_blob);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2MessagesSentByAccessory,
                        &theiAP2IdentificationInformationParameter->iAP2MessagesSentByAccessory_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2MessagesSentByAccessory",
                        iAP2_blob);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2PowerProvidingCapability,
                        &theiAP2IdentificationInformationParameter->iAP2PowerProvidingCapability_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2PowerProvidingCapability",
                        iAP2_enum);
    if(theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent_count;count++)
        {
            iAP2FreeiAP2SerialTransportComponent(&theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent);
        theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2SerialTransportComponent_count = 0;
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationParameter->iAP2SupportedLanguage,
                        &theiAP2IdentificationInformationParameter->iAP2SupportedLanguage_count,
                        (S8*)"theiAP2IdentificationInformationParameter->iAP2SupportedLanguage",
                        iAP2_utf8);
    if(theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent_count;count++)
        {
            iAP2FreeiAP2USBDeviceTransportComponent(&theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent);
        theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2USBDeviceTransportComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent_count;count++)
        {
            iAP2FreeiAP2USBHostHIDComponent(&theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent);
        theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2USBHostHIDComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent_count;count++)
        {
            iAP2FreeiAP2USBHostTransportComponent(&theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent);
        theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2USBHostTransportComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent_count;count++)
        {
            iAP2FreeiAP2VehicleInformationComponent(&theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent);
        theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2VehicleInformationComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent_count;count++)
        {
            iAP2FreeiAP2RouteGuidanceDisplayComponent(&theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent);
        theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2RouteGuidanceDisplayComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent_count;count++)
        {
            iAP2FreeiAP2VehicleStatusComponent(&theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent);
        theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2VehicleStatusComponent_count = 0;
    if(theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent_count;count++)
        {
            iAP2FreeiAP2WirelessCarPlayTransportComponent(&theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent[count]);
        }
        free(theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent);
        theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent = NULL;
    }
    else
    {
        if(theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent is NULL");
        }
    }
    theiAP2IdentificationInformationParameter->iAP2WirelessCarPlayTransportComponent_count = 0;
}

void iAP2FreeiAP2IdentificationInformationUpdateParameter(iAP2IdentificationInformationUpdateParameter* theiAP2IdentificationInformationUpdateParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryFirmwareVersion,
                        &theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryFirmwareVersion_count,
                        (S8*)"theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryFirmwareVersion",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryHardwareVersion,
                        &theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryHardwareVersion_count,
                        (S8*)"theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryHardwareVersion",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryManufacturer,
                        &theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryManufacturer_count,
                        (S8*)"theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryManufacturer",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryModelIdentifier,
                        &theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryModelIdentifier_count,
                        (S8*)"theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryModelIdentifier",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryName,
                        &theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryName_count,
                        (S8*)"theiAP2IdentificationInformationUpdateParameter->iAP2AccessoryName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationUpdateParameter->iAP2AccessorySerialNumber,
                        &theiAP2IdentificationInformationUpdateParameter->iAP2AccessorySerialNumber_count,
                        (S8*)"theiAP2IdentificationInformationUpdateParameter->iAP2AccessorySerialNumber",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2IdentificationInformationUpdateParameter->iAP2CurrentLanguage,
                        &theiAP2IdentificationInformationUpdateParameter->iAP2CurrentLanguage_count,
                        (S8*)"theiAP2IdentificationInformationUpdateParameter->iAP2CurrentLanguage",
                        iAP2_utf8);
}

void iAP2FreeiAP2RequestAppLaunchParameter(iAP2RequestAppLaunchParameter* theiAP2RequestAppLaunchParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestAppLaunchParameter->iAP2AppBundleID,
                        &theiAP2RequestAppLaunchParameter->iAP2AppBundleID_count,
                        (S8*)"theiAP2RequestAppLaunchParameter->iAP2AppBundleID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestAppLaunchParameter->iAP2LaunchAlert,
                        &theiAP2RequestAppLaunchParameter->iAP2LaunchAlert_count,
                        (S8*)"theiAP2RequestAppLaunchParameter->iAP2LaunchAlert",
                        iAP2_enum);
}

void iAP2FreeiAP2OOBBTPairingAccessoryInformationParameter(iAP2OOBBTPairingAccessoryInformationParameter* theiAP2OOBBTPairingAccessoryInformationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2OOBBTPairingAccessoryInformationParameter->iAP2BluetoothTransportComponentIdentifier,
                        &theiAP2OOBBTPairingAccessoryInformationParameter->iAP2BluetoothTransportComponentIdentifier_count,
                        (S8*)"theiAP2OOBBTPairingAccessoryInformationParameter->iAP2BluetoothTransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2OOBBTPairingAccessoryInformationParameter->iAP2DeviceClass,
                        &theiAP2OOBBTPairingAccessoryInformationParameter->iAP2DeviceClass_count,
                        (S8*)"theiAP2OOBBTPairingAccessoryInformationParameter->iAP2DeviceClass",
                        iAP2_uint32);
}

void iAP2FreeiAP2OOBBTPairingCompletionInformationParameter(iAP2OOBBTPairingCompletionInformationParameter* theiAP2OOBBTPairingCompletionInformationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2OOBBTPairingCompletionInformationParameter->iAP2ResultCode,
                        &theiAP2OOBBTPairingCompletionInformationParameter->iAP2ResultCode_count,
                        (S8*)"theiAP2OOBBTPairingCompletionInformationParameter->iAP2ResultCode",
                        iAP2_uint8);
}

void iAP2FreeiAP2StartRouteGuidanceUpdateParameter(iAP2StartRouteGuidanceUpdateParameter* theiAP2StartRouteGuidanceUpdateParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartRouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID,
                        &theiAP2StartRouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count,
                        (S8*)"theiAP2StartRouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID",
                        iAP2_uint16);
}

void iAP2FreeiAP2StopRouteGuidanceUpdateParameter(iAP2StopRouteGuidanceUpdateParameter* theiAP2StopRouteGuidanceUpdateParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StopRouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID,
                        &theiAP2StopRouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID_count,
                        (S8*)"theiAP2StopRouteGuidanceUpdateParameter->iAP2RouteGuidanceDisplayComponentID",
                        iAP2_uint16);
}

void iAP2FreeiAP2BluetoothComponentInformationParameter(iAP2BluetoothComponentInformationParameter* theiAP2BluetoothComponentInformationParameter)
{
    if(theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus_count;count++)
        {
            iAP2FreeiAP2BluetoothComponentStatus(&theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus[count]);
        }
        free(theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus);
        theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus = NULL;
    }
    else
    {
        if(theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus is NULL");
        }
    }
    theiAP2BluetoothComponentInformationParameter->iAP2BluetoothComponentStatus_count = 0;
}

void iAP2FreeiAP2BluetoothConnectionUpdateParameter(iAP2BluetoothConnectionUpdateParameter* theiAP2BluetoothConnectionUpdateParameter)
{
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles,
                        &theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles_count,
                        (S8*)"theiAP2BluetoothConnectionUpdateParameter->iAP2BluetoothComponentProfiles",
                        iAP2_group);
}

void iAP2FreeiAP2StartBluetoothConnectionUpdatesParameter(iAP2StartBluetoothConnectionUpdatesParameter* theiAP2StartBluetoothConnectionUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartBluetoothConnectionUpdatesParameter->iAP2BluetoothTransportComponentIdentifier,
                        &theiAP2StartBluetoothConnectionUpdatesParameter->iAP2BluetoothTransportComponentIdentifier_count,
                        (S8*)"theiAP2StartBluetoothConnectionUpdatesParameter->iAP2BluetoothTransportComponentIdentifier",
                        iAP2_uint16);
}

void iAP2FreeiAP2AcceptCallParameter(iAP2AcceptCallParameter* theiAP2AcceptCallParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2AcceptCallParameter->iAP2AcceptAction,
                        &theiAP2AcceptCallParameter->iAP2AcceptAction_count,
                        (S8*)"theiAP2AcceptCallParameter->iAP2AcceptAction",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2AcceptCallParameter->iAP2CallUUID,
                        &theiAP2AcceptCallParameter->iAP2CallUUID_count,
                        (S8*)"theiAP2AcceptCallParameter->iAP2CallUUID",
                        iAP2_utf8);
}

void iAP2FreeiAP2EndCallParameter(iAP2EndCallParameter* theiAP2EndCallParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2EndCallParameter->iAP2CallUUID,
                        &theiAP2EndCallParameter->iAP2CallUUID_count,
                        (S8*)"theiAP2EndCallParameter->iAP2CallUUID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2EndCallParameter->iAP2EndAction,
                        &theiAP2EndCallParameter->iAP2EndAction_count,
                        (S8*)"theiAP2EndCallParameter->iAP2EndAction",
                        iAP2_enum);
}

void iAP2FreeiAP2HoldStatusUpdateParameter(iAP2HoldStatusUpdateParameter* theiAP2HoldStatusUpdateParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2HoldStatusUpdateParameter->iAP2CallUUID,
                        &theiAP2HoldStatusUpdateParameter->iAP2CallUUID_count,
                        (S8*)"theiAP2HoldStatusUpdateParameter->iAP2CallUUID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2HoldStatusUpdateParameter->iAP2HoldStatusUpdate,
                        &theiAP2HoldStatusUpdateParameter->iAP2HoldStatusUpdate_count,
                        (S8*)"theiAP2HoldStatusUpdateParameter->iAP2HoldStatusUpdate",
                        iAP2_bool);
}

void iAP2FreeiAP2InitiateCallParameter(iAP2InitiateCallParameter* theiAP2InitiateCallParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2InitiateCallParameter->iAP2AddressBookID,
                        &theiAP2InitiateCallParameter->iAP2AddressBookID_count,
                        (S8*)"theiAP2InitiateCallParameter->iAP2AddressBookID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2InitiateCallParameter->iAP2DestinationID,
                        &theiAP2InitiateCallParameter->iAP2DestinationID_count,
                        (S8*)"theiAP2InitiateCallParameter->iAP2DestinationID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2InitiateCallParameter->iAP2Service,
                        &theiAP2InitiateCallParameter->iAP2Service_count,
                        (S8*)"theiAP2InitiateCallParameter->iAP2Service",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2InitiateCallParameter->iAP2Type,
                        &theiAP2InitiateCallParameter->iAP2Type_count,
                        (S8*)"theiAP2InitiateCallParameter->iAP2Type",
                        iAP2_enum);
}

void iAP2FreeiAP2ListUpdateParameter(iAP2ListUpdateParameter* theiAP2ListUpdateParameter)
{
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2ListUpdateParameter->iAP2FavoritesList,
                        &theiAP2ListUpdateParameter->iAP2FavoritesList_count,
                        (S8*)"theiAP2ListUpdateParameter->iAP2FavoritesList",
                        iAP2_group);
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2ListUpdateParameter->iAP2RecentsList,
                        &theiAP2ListUpdateParameter->iAP2RecentsList_count,
                        (S8*)"theiAP2ListUpdateParameter->iAP2RecentsList",
                        iAP2_group);
}

void iAP2FreeiAP2MuteStatusUpdateParameter(iAP2MuteStatusUpdateParameter* theiAP2MuteStatusUpdateParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2MuteStatusUpdateParameter->iAP2MuteStatus,
                        &theiAP2MuteStatusUpdateParameter->iAP2MuteStatus_count,
                        (S8*)"theiAP2MuteStatusUpdateParameter->iAP2MuteStatus",
                        iAP2_bool);
}

void iAP2FreeiAP2SendDTMFParameter(iAP2SendDTMFParameter* theiAP2SendDTMFParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2SendDTMFParameter->iAP2CallUUID,
                        &theiAP2SendDTMFParameter->iAP2CallUUID_count,
                        (S8*)"theiAP2SendDTMFParameter->iAP2CallUUID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2SendDTMFParameter->iAP2Tone,
                        &theiAP2SendDTMFParameter->iAP2Tone_count,
                        (S8*)"theiAP2SendDTMFParameter->iAP2Tone",
                        iAP2_enum);
}

void iAP2FreeiAP2StartCallStateUpdatesParameter(iAP2StartCallStateUpdatesParameter* theiAP2StartCallStateUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2AddressBookID,
                        &theiAP2StartCallStateUpdatesParameter->iAP2AddressBookID_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2AddressBookID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2CallUUID,
                        &theiAP2StartCallStateUpdatesParameter->iAP2CallUUID_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2CallUUID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2ConferenceGroup,
                        &theiAP2StartCallStateUpdatesParameter->iAP2ConferenceGroup_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2ConferenceGroup",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2Direction,
                        &theiAP2StartCallStateUpdatesParameter->iAP2Direction_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2Direction",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2DisconnectReason,
                        &theiAP2StartCallStateUpdatesParameter->iAP2DisconnectReason_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2DisconnectReason",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2DisplayName,
                        &theiAP2StartCallStateUpdatesParameter->iAP2DisplayName_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2DisplayName",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2IsConferenced,
                        &theiAP2StartCallStateUpdatesParameter->iAP2IsConferenced_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2IsConferenced",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2Label,
                        &theiAP2StartCallStateUpdatesParameter->iAP2Label_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2Label",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2RemoteID,
                        &theiAP2StartCallStateUpdatesParameter->iAP2RemoteID_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2RemoteID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2Service,
                        &theiAP2StartCallStateUpdatesParameter->iAP2Service_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2Service",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2Status,
                        &theiAP2StartCallStateUpdatesParameter->iAP2Status_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2Status",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCallStateUpdatesParameter->iAP2StartTimestamp,
                        &theiAP2StartCallStateUpdatesParameter->iAP2StartTimestamp_count,
                        (S8*)"theiAP2StartCallStateUpdatesParameter->iAP2StartTimestamp",
                        iAP2_none);
}

void iAP2FreeiAP2StartCommunicationsUpdatesParameter(iAP2StartCommunicationsUpdatesParameter* theiAP2StartCommunicationsUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2AirplaneModeStatus,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2AirplaneModeStatus_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2AirplaneModeStatus",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2CarrierName,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2CarrierName_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2CarrierName",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2CellularSupported,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2CellularSupported_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2CellularSupported",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2CurrentCallCount,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2CurrentCallCount_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2CurrentCallCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2EndAndAcceptAvailable,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2EndAndAcceptAvailable_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2EndAndAcceptAvailable",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2FaceTimeAudioEnabled,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2FaceTimeAudioEnabled_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2FaceTimeAudioEnabled",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2FaceTimeVideoEnabled,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2FaceTimeVideoEnabled_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2FaceTimeVideoEnabled",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2HoldAndAcceptAvailable,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2HoldAndAcceptAvailable_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2HoldAndAcceptAvailable",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2HoldAvailable,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2HoldAvailable_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2HoldAvailable",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2InitiateCallAvailable,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2InitiateCallAvailable_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2InitiateCallAvailable",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2MergeAvailable,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2MergeAvailable_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2MergeAvailable",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2MuteStatus,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2MuteStatus_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2MuteStatus",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2NewVoiceMailCount,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2NewVoiceMailCount_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2NewVoiceMailCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2RegistrationStatus,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2RegistrationStatus_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2RegistrationStatus",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2SignalStrength,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2SignalStrength_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2SignalStrength",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2SwapAvailable,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2SwapAvailable_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2SwapAvailable",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartCommunicationsUpdatesParameter->iAP2TelephonyEnabled,
                        &theiAP2StartCommunicationsUpdatesParameter->iAP2TelephonyEnabled_count,
                        (S8*)"theiAP2StartCommunicationsUpdatesParameter->iAP2TelephonyEnabled",
                        iAP2_none);
}

void iAP2FreeiAP2StartListUpdatesParameter(iAP2StartListUpdatesParameter* theiAP2StartListUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartListUpdatesParameter->iAP2FavoritesListMax,
                        &theiAP2StartListUpdatesParameter->iAP2FavoritesListMax_count,
                        (S8*)"theiAP2StartListUpdatesParameter->iAP2FavoritesListMax",
                        iAP2_uint16);
    if(theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties_count;count++)
        {
            iAP2FreeiAP2FavoritesListProperties(&theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties[count]);
        }
        free(theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties);
        theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties = NULL;
    }
    else
    {
        if(theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties is NULL");
        }
    }
    theiAP2StartListUpdatesParameter->iAP2FavoritesListProperties_count = 0;
    iAP2FreeiAP2Pointer((void**)&theiAP2StartListUpdatesParameter->iAP2RecentListCombine,
                        &theiAP2StartListUpdatesParameter->iAP2RecentListCombine_count,
                        (S8*)"theiAP2StartListUpdatesParameter->iAP2RecentListCombine",
                        iAP2_bool);
    if(theiAP2StartListUpdatesParameter->iAP2RecentListProperties != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartListUpdatesParameter->iAP2RecentListProperties_count;count++)
        {
            iAP2FreeiAP2RecentsListProperties(&theiAP2StartListUpdatesParameter->iAP2RecentListProperties[count]);
        }
        free(theiAP2StartListUpdatesParameter->iAP2RecentListProperties);
        theiAP2StartListUpdatesParameter->iAP2RecentListProperties = NULL;
    }
    else
    {
        if(theiAP2StartListUpdatesParameter->iAP2RecentListProperties_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartListUpdatesParameter->iAP2RecentListProperties is NULL");
        }
    }
    theiAP2StartListUpdatesParameter->iAP2RecentListProperties_count = 0;
    iAP2FreeiAP2Pointer((void**)&theiAP2StartListUpdatesParameter->iAP2RecentsListMax,
                        &theiAP2StartListUpdatesParameter->iAP2RecentsListMax_count,
                        (S8*)"theiAP2StartListUpdatesParameter->iAP2RecentsListMax",
                        iAP2_uint16);
}

void iAP2FreeiAP2RequestDeviceAuthenticationChallengeResponseParameter(iAP2RequestDeviceAuthenticationChallengeResponseParameter* theiAP2RequestDeviceAuthenticationChallengeResponseParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestDeviceAuthenticationChallengeResponseParameter->iAP2DeviceAuthenticationChallenge,
                        &theiAP2RequestDeviceAuthenticationChallengeResponseParameter->iAP2DeviceAuthenticationChallenge_count,
                        (S8*)"theiAP2RequestDeviceAuthenticationChallengeResponseParameter->iAP2DeviceAuthenticationChallenge",
                        iAP2_blob);
}

void iAP2FreeiAP2StatusExternalAccessoryProtocolSessionParameter(iAP2StatusExternalAccessoryProtocolSessionParameter* theiAP2StatusExternalAccessoryProtocolSessionParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StatusExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier,
                        &theiAP2StatusExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier_count,
                        (S8*)"theiAP2StatusExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2StatusExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionStatus,
                        &theiAP2StatusExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionStatus_count,
                        (S8*)"theiAP2StatusExternalAccessoryProtocolSessionParameter->iAP2ExternalAccessoryProtocolSessionStatus",
                        iAP2_enum);
}

void iAP2FreeiAP2AccessoryHIDReportParameter(iAP2AccessoryHIDReportParameter* theiAP2AccessoryHIDReportParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2AccessoryHIDReportParameter->iAP2HIDComponentIdentifier,
                        &theiAP2AccessoryHIDReportParameter->iAP2HIDComponentIdentifier_count,
                        (S8*)"theiAP2AccessoryHIDReportParameter->iAP2HIDComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2AccessoryHIDReportParameter->iAP2HIDReport,
                        &theiAP2AccessoryHIDReportParameter->iAP2HIDReport_count,
                        (S8*)"theiAP2AccessoryHIDReportParameter->iAP2HIDReport",
                        iAP2_blob);
}

void iAP2FreeiAP2StartHIDParameter(iAP2StartHIDParameter* theiAP2StartHIDParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartHIDParameter->iAP2HIDComponentIdentifier,
                        &theiAP2StartHIDParameter->iAP2HIDComponentIdentifier_count,
                        (S8*)"theiAP2StartHIDParameter->iAP2HIDComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartHIDParameter->iAP2HIDReportDescriptor,
                        &theiAP2StartHIDParameter->iAP2HIDReportDescriptor_count,
                        (S8*)"theiAP2StartHIDParameter->iAP2HIDReportDescriptor",
                        iAP2_blob);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartHIDParameter->iAP2LocalizedKeyboardCountryCode,
                        &theiAP2StartHIDParameter->iAP2LocalizedKeyboardCountryCode_count,
                        (S8*)"theiAP2StartHIDParameter->iAP2LocalizedKeyboardCountryCode",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartHIDParameter->iAP2ProductIdentifier,
                        &theiAP2StartHIDParameter->iAP2ProductIdentifier_count,
                        (S8*)"theiAP2StartHIDParameter->iAP2ProductIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartHIDParameter->iAP2VendorIdentifier,
                        &theiAP2StartHIDParameter->iAP2VendorIdentifier_count,
                        (S8*)"theiAP2StartHIDParameter->iAP2VendorIdentifier",
                        iAP2_uint16);
}

void iAP2FreeiAP2StopHIDParameter(iAP2StopHIDParameter* theiAP2StopHIDParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StopHIDParameter->iAP2HIDComponentIdentifier,
                        &theiAP2StopHIDParameter->iAP2HIDComponentIdentifier_count,
                        (S8*)"theiAP2StopHIDParameter->iAP2HIDComponentIdentifier",
                        iAP2_uint16);
}

void iAP2FreeiAP2LocationInformationParameter(iAP2LocationInformationParameter* theiAP2LocationInformationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationParameter->iAP2NMEASentence,
                        &theiAP2LocationInformationParameter->iAP2NMEASentence_count,
                        (S8*)"theiAP2LocationInformationParameter->iAP2NMEASentence",
                        iAP2_utf8);
}

void iAP2FreeiAP2MediaLibraryInformationParameter(iAP2MediaLibraryInformationParameter* theiAP2MediaLibraryInformationParameter)
{
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter,
                        &theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter_count,
                        (S8*)"theiAP2MediaLibraryInformationParameter->iAP2MediaLibraryInformationSubParameter",
                        iAP2_group);
}

void iAP2FreeiAP2MediaLibraryUpdateParameter(iAP2MediaLibraryUpdateParameter* theiAP2MediaLibraryUpdateParameter)
{
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaLibraryUpdateParameter->iAP2MediaItem,
                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaItem_count,
                        (S8*)"theiAP2MediaLibraryUpdateParameter->iAP2MediaItem",
                        iAP2_group);
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList,
                        &theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList_count,
                        (S8*)"theiAP2MediaLibraryUpdateParameter->iAP2MediaPlayList",
                        iAP2_group);
}

void iAP2FreeiAP2PlayMediaLibraryCollectionParameter(iAP2PlayMediaLibraryCollectionParameter* theiAP2PlayMediaLibraryCollectionParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionPersistentIdentifier,
                        &theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionPersistentIdentifier_count,
                        (S8*)"theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionPersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionStartingIndex,
                        &theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionStartingIndex_count,
                        (S8*)"theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionStartingIndex",
                        iAP2_uint32);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionType,
                        &theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionType_count,
                        (S8*)"theiAP2PlayMediaLibraryCollectionParameter->iAP2CollectionType",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryCollectionParameter->iAP2MediaLibraryUniqueIdentifier,
                        &theiAP2PlayMediaLibraryCollectionParameter->iAP2MediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2PlayMediaLibraryCollectionParameter->iAP2MediaLibraryUniqueIdentifier",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryCollectionParameter->iAP2StartingMediaItemPersistentIdentifier,
                        &theiAP2PlayMediaLibraryCollectionParameter->iAP2StartingMediaItemPersistentIdentifier_count,
                        (S8*)"theiAP2PlayMediaLibraryCollectionParameter->iAP2StartingMediaItemPersistentIdentifier",
                        iAP2_uint64);
}

void iAP2FreeiAP2PlayMediaLibraryCurrentSelectionParameter(iAP2PlayMediaLibraryCurrentSelectionParameter* theiAP2PlayMediaLibraryCurrentSelectionParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryCurrentSelectionParameter->MediaLibraryUniqueIdentifier,
                        &theiAP2PlayMediaLibraryCurrentSelectionParameter->MediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2PlayMediaLibraryCurrentSelectionParameter->MediaLibraryUniqueIdentifier",
                        iAP2_utf8);
}

void iAP2FreeiAP2PlayMediaLibraryItemsParameter(iAP2PlayMediaLibraryItemsParameter* theiAP2PlayMediaLibraryItemsParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryItemsParameter->iAP2ItemsPersistentIdentifiers,
                        &theiAP2PlayMediaLibraryItemsParameter->iAP2ItemsPersistentIdentifiers_count,
                        (S8*)"theiAP2PlayMediaLibraryItemsParameter->iAP2ItemsPersistentIdentifiers",
                        iAP2_blob);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryItemsParameter->ItemsStartingIndex,
                        &theiAP2PlayMediaLibraryItemsParameter->ItemsStartingIndex_count,
                        (S8*)"theiAP2PlayMediaLibraryItemsParameter->ItemsStartingIndex",
                        iAP2_uint32);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibraryItemsParameter->MediaLibraryUniqueIdentifier,
                        &theiAP2PlayMediaLibraryItemsParameter->MediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2PlayMediaLibraryItemsParameter->MediaLibraryUniqueIdentifier",
                        iAP2_utf8);
}

void iAP2FreeiAP2PlayMediaLibrarySpecialParameter(iAP2PlayMediaLibrarySpecialParameter* theiAP2PlayMediaLibrarySpecialParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibrarySpecialParameter->iAP2AllSongs,
                        &theiAP2PlayMediaLibrarySpecialParameter->iAP2AllSongs_count,
                        (S8*)"theiAP2PlayMediaLibrarySpecialParameter->iAP2AllSongs",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibrarySpecialParameter->iAP2MediaLibraryUniqueIdentifier,
                        &theiAP2PlayMediaLibrarySpecialParameter->iAP2MediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2PlayMediaLibrarySpecialParameter->iAP2MediaLibraryUniqueIdentifier",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlayMediaLibrarySpecialParameter->iAP2StartingMediaItemPersistentIdentifier,
                        &theiAP2PlayMediaLibrarySpecialParameter->iAP2StartingMediaItemPersistentIdentifier_count,
                        (S8*)"theiAP2PlayMediaLibrarySpecialParameter->iAP2StartingMediaItemPersistentIdentifier",
                        iAP2_uint64);
}

void iAP2FreeiAP2StartMediaLibraryUpdatesParameter(iAP2StartMediaLibraryUpdatesParameter* theiAP2StartMediaLibraryUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartMediaLibraryUpdatesParameter->iAP2LastKnownMediaLibraryRevision,
                        &theiAP2StartMediaLibraryUpdatesParameter->iAP2LastKnownMediaLibraryRevision_count,
                        (S8*)"theiAP2StartMediaLibraryUpdatesParameter->iAP2LastKnownMediaLibraryRevision",
                        iAP2_utf8);
    if(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties_count;count++)
        {
            iAP2FreeiAP2MediaItemProperties(&theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties[count]);
        }
        free(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties);
        theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties = NULL;
    }
    else
    {
        if(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties is NULL");
        }
    }
    theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaItemProperties_count = 0;
    iAP2FreeiAP2Pointer((void**)&theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryIsHidingRemoteItems,
                        &theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryIsHidingRemoteItems_count,
                        (S8*)"theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryIsHidingRemoteItems",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryUniqueIdentifier,
                        &theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryUniqueIdentifier",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryUpdateProgress,
                        &theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryUpdateProgress_count,
                        (S8*)"theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaLibraryUpdateProgress",
                        iAP2_none);
    if(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties_count;count++)
        {
            iAP2FreeiAP2MediaPlaylistProperties(&theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties[count]);
        }
        free(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties);
        theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties = NULL;
    }
    else
    {
        if(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties is NULL");
        }
    }
    theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistProperties_count = 0;
    iAP2FreeiAP2Pointer((void**)&theiAP2StartMediaLibraryUpdatesParameter->iAP2PlayAllSongsCapable,
                        &theiAP2StartMediaLibraryUpdatesParameter->iAP2PlayAllSongsCapable_count,
                        (S8*)"theiAP2StartMediaLibraryUpdatesParameter->iAP2PlayAllSongsCapable",
                        iAP2_none);
    if(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest_count;count++)
        {
            iAP2FreeiAP2MediaPlaylistContentTransferInfoRequest(&theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest[count]);
        }
        free(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest);
        theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest = NULL;
    }
    else
    {
        if(theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest is NULL");
        }
    }
    theiAP2StartMediaLibraryUpdatesParameter->iAP2MediaPlaylistContentTransferInfoRequest_count = 0;
}

void iAP2FreeiAP2StopMediaLibraryUpdatesParameter(iAP2StopMediaLibraryUpdatesParameter* theiAP2StopMediaLibraryUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StopMediaLibraryUpdatesParameter->iAP2MediaLibraryUniqueIdentifier,
                        &theiAP2StopMediaLibraryUpdatesParameter->iAP2MediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2StopMediaLibraryUpdatesParameter->iAP2MediaLibraryUniqueIdentifier",
                        iAP2_utf8);
}

void iAP2FreeiAP2NowPlayingUpdateParameter(iAP2NowPlayingUpdateParameter* theiAP2NowPlayingUpdateParameter)
{
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes,
                        &theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes_count,
                        (S8*)"theiAP2NowPlayingUpdateParameter->iAP2MediaItemAttributes",
                        iAP2_group);
    /* As memory is allocated only for group type, freeing them alone is sufficient enough */
    iAP2FreeiAP2Pointer((void**)&theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes,
                        &theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes_count,
                        (S8*)"theiAP2NowPlayingUpdateParameter->iAP2PlaybackAttributes",
                        iAP2_group);
}

void iAP2FreeiAP2SetNowPlayingInformationParameter(iAP2SetNowPlayingInformationParameter* theiAP2SetNowPlayingInformationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2SetNowPlayingInformationParameter->iAP2ElapsedTime,
                        &theiAP2SetNowPlayingInformationParameter->iAP2ElapsedTime_count,
                        (S8*)"theiAP2SetNowPlayingInformationParameter->iAP2ElapsedTime",
                        iAP2_uint32);
    iAP2FreeiAP2Pointer((void**)&theiAP2SetNowPlayingInformationParameter->iAP2PlaybackQueueIndex,
                        &theiAP2SetNowPlayingInformationParameter->iAP2PlaybackQueueIndex_count,
                        (S8*)"theiAP2SetNowPlayingInformationParameter->iAP2PlaybackQueueIndex",
                        iAP2_uint32);
    iAP2FreeiAP2Pointer((void**)&theiAP2SetNowPlayingInformationParameter->iAP2PlaybackQueueListContentTransferStartIndex,
                        &theiAP2SetNowPlayingInformationParameter->iAP2PlaybackQueueListContentTransferStartIndex_count,
                        (S8*)"theiAP2SetNowPlayingInformationParameter->iAP2PlaybackQueueListContentTransferStartIndex",
                        iAP2_uint32);
}

void iAP2FreeiAP2StartNowPlayingUpdatesParameter(iAP2StartNowPlayingUpdatesParameter* theiAP2StartNowPlayingUpdatesParameter)
{
    if(theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes_count;count++)
        {
            iAP2FreeiAP2MediaItemAttributes(&theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes[count]);
        }
        free(theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes);
        theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes = NULL;
    }
    else
    {
        if(theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes is NULL");
        }
    }
    theiAP2StartNowPlayingUpdatesParameter->iAP2MediaItemAttributes_count = 0;
    if(theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes_count;count++)
        {
            iAP2FreeiAP2StartNowPlayingPlaybackAttributes(&theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes[count]);
        }
        free(theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes);
        theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes = NULL;
    }
    else
    {
        if(theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes is NULL");
        }
    }
    theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackAttributes_count = 0;
    if(theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest != NULL)
    {
        U16 count;

        for(count=0; count<theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest_count;count++)
        {
            iAP2FreeiAP2PlaybackQueueListContentTransferInfoRequest(&theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest[count]);
        }
        free(theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest);
        theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest = NULL;
    }
    else
    {
        if(theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest_count != 0)
        {
            IAP2SESSIONDLTLOG(DLT_LOG_WARN, "theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest is NULL");
        }
    }
    theiAP2StartNowPlayingUpdatesParameter->iAP2PlaybackQueueListContentTransferInfoRequest_count = 0;
}

void iAP2FreeiAP2PowerSourceUpdateParameter(iAP2PowerSourceUpdateParameter* theiAP2PowerSourceUpdateParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2PowerSourceUpdateParameter->iAP2AvailableCurrentForDevice,
                        &theiAP2PowerSourceUpdateParameter->iAP2AvailableCurrentForDevice_count,
                        (S8*)"theiAP2PowerSourceUpdateParameter->iAP2AvailableCurrentForDevice",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2PowerSourceUpdateParameter->iAP2DeviceBatteryShouldChargeIfPowerIsPresent,
                        &theiAP2PowerSourceUpdateParameter->iAP2DeviceBatteryShouldChargeIfPowerIsPresent_count,
                        (S8*)"theiAP2PowerSourceUpdateParameter->iAP2DeviceBatteryShouldChargeIfPowerIsPresent",
                        iAP2_bool);
}

void iAP2FreeiAP2StartPowerUpdatesParameter(iAP2StartPowerUpdatesParameter* theiAP2StartPowerUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartPowerUpdatesParameter->iAP2AccessoryPowerMode,
                        &theiAP2StartPowerUpdatesParameter->iAP2AccessoryPowerMode_count,
                        (S8*)"theiAP2StartPowerUpdatesParameter->iAP2AccessoryPowerMode",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartPowerUpdatesParameter->iAP2BatteryChargeLevel,
                        &theiAP2StartPowerUpdatesParameter->iAP2BatteryChargeLevel_count,
                        (S8*)"theiAP2StartPowerUpdatesParameter->iAP2BatteryChargeLevel",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartPowerUpdatesParameter->iAP2BatteryChargingState,
                        &theiAP2StartPowerUpdatesParameter->iAP2BatteryChargingState_count,
                        (S8*)"theiAP2StartPowerUpdatesParameter->iAP2BatteryChargingState",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartPowerUpdatesParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent,
                        &theiAP2StartPowerUpdatesParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent_count,
                        (S8*)"theiAP2StartPowerUpdatesParameter->iAP2DeviceBatteryWillChargeIfPowerIsPresent",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartPowerUpdatesParameter->iAP2IsExternalChargerConnected,
                        &theiAP2StartPowerUpdatesParameter->iAP2IsExternalChargerConnected_count,
                        (S8*)"theiAP2StartPowerUpdatesParameter->iAP2IsExternalChargerConnected",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartPowerUpdatesParameter->iAP2MaximumcurrentDrawnFromAccessory,
                        &theiAP2StartPowerUpdatesParameter->iAP2MaximumcurrentDrawnFromAccessory_count,
                        (S8*)"theiAP2StartPowerUpdatesParameter->iAP2MaximumcurrentDrawnFromAccessory",
                        iAP2_none);
}

void iAP2FreeiAP2StartTelephonyCallStateInformationParameter(iAP2StartTelephonyCallStateInformationParameter* theiAP2StartTelephonyCallStateInformationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartTelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier,
                        &theiAP2StartTelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier_count,
                        (S8*)"theiAP2StartTelephonyCallStateInformationParameter->iAP2CallStatevCardFileTransferIdentifier",
                        iAP2_none);
}

void iAP2FreeiAP2StartTelephonyUpdatesParameter(iAP2StartTelephonyUpdatesParameter* theiAP2StartTelephonyUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartTelephonyUpdatesParameter->iAP2TelephonySignalStrength,
                        &theiAP2StartTelephonyUpdatesParameter->iAP2TelephonySignalStrength_count,
                        (S8*)"theiAP2StartTelephonyUpdatesParameter->iAP2TelephonySignalStrength",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyRegistrationStatus,
                        &theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyRegistrationStatus_count,
                        (S8*)"theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyRegistrationStatus",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyAirplaneModeStatus,
                        &theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyAirplaneModeStatus_count,
                        (S8*)"theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyAirplaneModeStatus",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyTTYStatus,
                        &theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyTTYStatus_count,
                        (S8*)"theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyTTYStatus",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyMobileOperator,
                        &theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyMobileOperator_count,
                        (S8*)"theiAP2StartTelephonyUpdatesParameter->iAP2TelephonyMobileOperator",
                        iAP2_none);
}

void iAP2FreeiAP2VehicleStatusUpdateParameter(iAP2VehicleStatusUpdateParameter* theiAP2VehicleStatusUpdateParameter)
{
    if(theiAP2VehicleStatusUpdateParameter->iAP2NightMode != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2NightMode is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusUpdateParameter->iAP2NightMode,
                        &theiAP2VehicleStatusUpdateParameter->iAP2NightMode_count,
                        (S8*)"theiAP2VehicleStatusUpdateParameter->iAP2NightMode",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusUpdateParameter->iAP2Range,
                        &theiAP2VehicleStatusUpdateParameter->iAP2Range_count,
                        (S8*)"theiAP2VehicleStatusUpdateParameter->iAP2Range",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusUpdateParameter->iAP2OutsideTemperature,
                        &theiAP2VehicleStatusUpdateParameter->iAP2OutsideTemperature_count,
                        (S8*)"theiAP2VehicleStatusUpdateParameter->iAP2OutsideTemperature",
                        iAP2_int16);
    if(theiAP2VehicleStatusUpdateParameter->iAP2InsideTemperature != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusUpdateParameter->iAP2InsideTemperature,
                        &theiAP2VehicleStatusUpdateParameter->iAP2InsideTemperature_count,
                        (S8*)"theiAP2VehicleStatusUpdateParameter->iAP2InsideTemperature",
                        iAP2_int16);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusUpdateParameter->iAP2RangeWarning,
                        &theiAP2VehicleStatusUpdateParameter->iAP2RangeWarning_count,
                        (S8*)"theiAP2VehicleStatusUpdateParameter->iAP2RangeWarning",
                        iAP2_bool);
}

void iAP2FreeiAP2RequestVoiceOverConfigurationParameter(iAP2RequestVoiceOverConfigurationParameter* theiAP2RequestVoiceOverConfigurationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestVoiceOverConfigurationParameter->iAP2VoiceOverSpeakingRate,
                        &theiAP2RequestVoiceOverConfigurationParameter->iAP2VoiceOverSpeakingRate_count,
                        (S8*)"theiAP2RequestVoiceOverConfigurationParameter->iAP2VoiceOverSpeakingRate",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestVoiceOverConfigurationParameter->iAP2VoiceOverSpeakingVolume,
                        &theiAP2RequestVoiceOverConfigurationParameter->iAP2VoiceOverSpeakingVolume_count,
                        (S8*)"theiAP2RequestVoiceOverConfigurationParameter->iAP2VoiceOverSpeakingVolume",
                        iAP2_uint8);
}

void iAP2FreeiAP2RequestVoiceOverMoveCursorParameter(iAP2RequestVoiceOverMoveCursorParameter* theiAP2RequestVoiceOverMoveCursorParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestVoiceOverMoveCursorParameter->iAP2CursorDirection,
                        &theiAP2RequestVoiceOverMoveCursorParameter->iAP2CursorDirection_count,
                        (S8*)"theiAP2RequestVoiceOverMoveCursorParameter->iAP2CursorDirection",
                        iAP2_enum);
}

void iAP2FreeiAP2RequestVoiceOverScrollPageParameter(iAP2RequestVoiceOverScrollPageParameter* theiAP2RequestVoiceOverScrollPageParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestVoiceOverScrollPageParameter->iAP2ScrollDirection,
                        &theiAP2RequestVoiceOverScrollPageParameter->iAP2ScrollDirection_count,
                        (S8*)"theiAP2RequestVoiceOverScrollPageParameter->iAP2ScrollDirection",
                        iAP2_enum);
}

void iAP2FreeiAP2RequestVoiceOverSpeakTextParameter(iAP2RequestVoiceOverSpeakTextParameter* theiAP2RequestVoiceOverSpeakTextParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RequestVoiceOverSpeakTextParameter->iAP2VoiceOverTextToSpeak,
                        &theiAP2RequestVoiceOverSpeakTextParameter->iAP2VoiceOverTextToSpeak_count,
                        (S8*)"theiAP2RequestVoiceOverSpeakTextParameter->iAP2VoiceOverTextToSpeak",
                        iAP2_utf8);
}

void iAP2FreeiAP2StartVoiceOverCursorUpdatesParameter(iAP2StartVoiceOverCursorUpdatesParameter* theiAP2StartVoiceOverCursorUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverHint,
                        &theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverHint_count,
                        (S8*)"theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverHint",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverLabel,
                        &theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverLabel_count,
                        (S8*)"theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverLabel",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverTraits,
                        &theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverTraits_count,
                        (S8*)"theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverTraits",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverValue,
                        &theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverValue_count,
                        (S8*)"theiAP2StartVoiceOverCursorUpdatesParameter->iAP2VoiceOverValue",
                        iAP2_none);
}

void iAP2FreeiAP2StartVoiceOverUpdatesParameter(iAP2StartVoiceOverUpdatesParameter* theiAP2StartVoiceOverUpdatesParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverEnabled,
                        &theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverEnabled_count,
                        (S8*)"theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverEnabled",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverSpeakingRate,
                        &theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverSpeakingRate_count,
                        (S8*)"theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverSpeakingRate",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverSpeakingVolume,
                        &theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverSpeakingVolume_count,
                        (S8*)"theiAP2StartVoiceOverUpdatesParameter->iAP2VoiceOverSpeakingVolume",
                        iAP2_none);
}

void iAP2FreeiAP2AccessoryWiFiConfigurationInformationParameter(iAP2AccessoryWiFiConfigurationInformationParameter* theiAP2AccessoryWiFiConfigurationInformationParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2Channel,
                        &theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2Channel_count,
                        (S8*)"theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2Channel",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2Passphrase,
                        &theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2Passphrase_count,
                        (S8*)"theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2Passphrase",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2SecurityType,
                        &theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2SecurityType_count,
                        (S8*)"theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2SecurityType",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2WiFiSSID,
                        &theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2WiFiSSID_count,
                        (S8*)"theiAP2AccessoryWiFiConfigurationInformationParameter->iAP2WiFiSSID",
                        iAP2_utf8);
}

void iAP2FreeiAP2BluetoothComponentProfiles(iAP2BluetoothComponentProfiles* theiAP2BluetoothComponentProfiles)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothAdvancedAudioDistributionProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothAdvancedAudioDistributionProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothAdvancedAudioDistributionProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothAudioVideoRemotecontrolProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothAudioVideoRemotecontrolProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothAudioVideoRemotecontrolProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothHandsFreeProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothHandsFreeProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothHandsFreeProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothHumanInterfaceDeviceProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothHumanInterfaceDeviceProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothHumanInterfaceDeviceProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothiAP2LinkProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothiAP2LinkProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothiAP2LinkProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothMessageAccessProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothMessageAccessProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothMessageAccessProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkAccessPointProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkAccessPointProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkAccessPointProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkClientProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkClientProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothPersonalAreaNetworkClientProfile",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentProfiles->iAP2BluetoothPhoneBookAccessProfile,
                        &theiAP2BluetoothComponentProfiles->iAP2BluetoothPhoneBookAccessProfile_count,
                        (S8*)"theiAP2BluetoothComponentProfiles->iAP2BluetoothPhoneBookAccessProfile",
                        iAP2_none);
}

void iAP2FreeiAP2BluetoothComponentStatus(iAP2BluetoothComponentStatus* theiAP2BluetoothComponentStatus)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentStatus->iAP2BTComponentEnabled,
                        &theiAP2BluetoothComponentStatus->iAP2BTComponentEnabled_count,
                        (S8*)"theiAP2BluetoothComponentStatus->iAP2BTComponentEnabled",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothComponentStatus->iAP2BTComponentIdentifier,
                        &theiAP2BluetoothComponentStatus->iAP2BTComponentIdentifier_count,
                        (S8*)"theiAP2BluetoothComponentStatus->iAP2BTComponentIdentifier",
                        iAP2_uint16);
}

void iAP2FreeiAP2BluetoothHIDComponent(iAP2BluetoothHIDComponent* theiAP2BluetoothHIDComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothHIDComponent->iAP2BluetoothTransportComponentIdentifier,
                        &theiAP2BluetoothHIDComponent->iAP2BluetoothTransportComponentIdentifier_count,
                        (S8*)"theiAP2BluetoothHIDComponent->iAP2BluetoothTransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothHIDComponent->iAP2HIDComponentFunction,
                        &theiAP2BluetoothHIDComponent->iAP2HIDComponentFunction_count,
                        (S8*)"theiAP2BluetoothHIDComponent->iAP2HIDComponentFunction",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothHIDComponent->iAP2HIDComponentIdentifier,
                        &theiAP2BluetoothHIDComponent->iAP2HIDComponentIdentifier_count,
                        (S8*)"theiAP2BluetoothHIDComponent->iAP2HIDComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothHIDComponent->iAP2HIDComponentName,
                        &theiAP2BluetoothHIDComponent->iAP2HIDComponentName_count,
                        (S8*)"theiAP2BluetoothHIDComponent->iAP2HIDComponentName",
                        iAP2_utf8);
}

void iAP2FreeiAP2BluetoothTransportComponent(iAP2BluetoothTransportComponent* theiAP2BluetoothTransportComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothTransportComponent->iAP2BluetoothTransportMediaAccessControlAddress,
                        &theiAP2BluetoothTransportComponent->iAP2BluetoothTransportMediaAccessControlAddress_count,
                        (S8*)"theiAP2BluetoothTransportComponent->iAP2BluetoothTransportMediaAccessControlAddress",
                        iAP2_blob);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothTransportComponent->iAP2TransportComponentIdentifier,
                        &theiAP2BluetoothTransportComponent->iAP2TransportComponentIdentifier_count,
                        (S8*)"theiAP2BluetoothTransportComponent->iAP2TransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothTransportComponent->iAP2TransportComponentName,
                        &theiAP2BluetoothTransportComponent->iAP2TransportComponentName_count,
                        (S8*)"theiAP2BluetoothTransportComponent->iAP2TransportComponentName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2BluetoothTransportComponent->iAP2TransportSupportsiAP2Connection,
                        &theiAP2BluetoothTransportComponent->iAP2TransportSupportsiAP2Connection_count,
                        (S8*)"theiAP2BluetoothTransportComponent->iAP2TransportSupportsiAP2Connection",
                        iAP2_none);
}

void iAP2FreeiAP2ExternalAccessoryProtocol(iAP2ExternalAccessoryProtocol* theiAP2ExternalAccessoryProtocol)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolCarPlay,
                        &theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolCarPlay_count,
                        (S8*)"theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolCarPlay",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolIdentifier,
                        &theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolIdentifier_count,
                        (S8*)"theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolIdentifier",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolMatchAction,
                        &theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolMatchAction_count,
                        (S8*)"theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolMatchAction",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolName,
                        &theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolName_count,
                        (S8*)"theiAP2ExternalAccessoryProtocol->iAP2ExternalAccessoryProtocolName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2ExternalAccessoryProtocol->iAP2NativeTransportComponentIdentifier,
                        &theiAP2ExternalAccessoryProtocol->iAP2NativeTransportComponentIdentifier_count,
                        (S8*)"theiAP2ExternalAccessoryProtocol->iAP2NativeTransportComponentIdentifier",
                        iAP2_uint16);
}

void iAP2FreeiAP2FavoritesList(iAP2FavoritesList* theiAP2FavoritesList)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesList->iAP2AddressBookID,
                        &theiAP2FavoritesList->iAP2AddressBookID_count,
                        (S8*)"theiAP2FavoritesList->iAP2AddressBookID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesList->iAP2DisplayName,
                        &theiAP2FavoritesList->iAP2DisplayName_count,
                        (S8*)"theiAP2FavoritesList->iAP2DisplayName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesList->iAP2Index,
                        &theiAP2FavoritesList->iAP2Index_count,
                        (S8*)"theiAP2FavoritesList->iAP2Index",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesList->iAP2Label,
                        &theiAP2FavoritesList->iAP2Label_count,
                        (S8*)"theiAP2FavoritesList->iAP2Label",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesList->iAP2RemoteID,
                        &theiAP2FavoritesList->iAP2RemoteID_count,
                        (S8*)"theiAP2FavoritesList->iAP2RemoteID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesList->iAP2Service,
                        &theiAP2FavoritesList->iAP2Service_count,
                        (S8*)"theiAP2FavoritesList->iAP2Service",
                        iAP2_enum);
}

void iAP2FreeiAP2FavoritesListProperties(iAP2FavoritesListProperties* theiAP2FavoritesListProperties)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesListProperties->iAP2AddressBookID,
                        &theiAP2FavoritesListProperties->iAP2AddressBookID_count,
                        (S8*)"theiAP2FavoritesListProperties->iAP2AddressBookID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesListProperties->iAP2DisplayName,
                        &theiAP2FavoritesListProperties->iAP2DisplayName_count,
                        (S8*)"theiAP2FavoritesListProperties->iAP2DisplayName",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesListProperties->iAP2Index,
                        &theiAP2FavoritesListProperties->iAP2Index_count,
                        (S8*)"theiAP2FavoritesListProperties->iAP2Index",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesListProperties->iAP2Label,
                        &theiAP2FavoritesListProperties->iAP2Label_count,
                        (S8*)"theiAP2FavoritesListProperties->iAP2Label",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesListProperties->iAP2RemoteID,
                        &theiAP2FavoritesListProperties->iAP2RemoteID_count,
                        (S8*)"theiAP2FavoritesListProperties->iAP2RemoteID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2FavoritesListProperties->iAP2Service,
                        &theiAP2FavoritesListProperties->iAP2Service_count,
                        (S8*)"theiAP2FavoritesListProperties->iAP2Service",
                        iAP2_none);
}

void iAP2FreeiAP2iAP2HIDComponent(iAP2iAP2HIDComponent* theiAP2iAP2HIDComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2iAP2HIDComponent->iAP2HIDComponentFunction,
                        &theiAP2iAP2HIDComponent->iAP2HIDComponentFunction_count,
                        (S8*)"theiAP2iAP2HIDComponent->iAP2HIDComponentFunction",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2iAP2HIDComponent->iAP2HIDComponentIdentifier,
                        &theiAP2iAP2HIDComponent->iAP2HIDComponentIdentifier_count,
                        (S8*)"theiAP2iAP2HIDComponent->iAP2HIDComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2iAP2HIDComponent->iAP2HIDComponentName,
                        &theiAP2iAP2HIDComponent->iAP2HIDComponentName_count,
                        (S8*)"theiAP2iAP2HIDComponent->iAP2HIDComponentName",
                        iAP2_utf8);
}

void iAP2FreeiAP2LocationInformationComponent(iAP2LocationInformationComponent* theiAP2LocationInformationComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentGlobalPositioningSystemFixData,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentGlobalPositioningSystemFixData_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentGlobalPositioningSystemFixData",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentGPSSatelliteInView,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentGPSSatelliteInView_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentGPSSatelliteInView",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentIdentifier,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentIdentifier_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentName,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentName_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentRecommendedMinimumSpecificGPSTransitData",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleAccelerometerData,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleAccelerometerData_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleAccelerometerData",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleGyroData,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleGyroData_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleGyroData",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleHeadingData,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleHeadingData_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleHeadingData",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleSpeedData,
                        &theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleSpeedData_count,
                        (S8*)"theiAP2LocationInformationComponent->iAP2LocationInformationComponentVehicleSpeedData",
                        iAP2_none);
}

void iAP2FreeiAP2MediaItem(iAP2MediaItem* theiAP2MediaItem)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumArtist,
                        &theiAP2MediaItem->iAP2MediaItemAlbumArtist_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumArtist",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier,
                        &theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumArtistPersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumDiscCount,
                        &theiAP2MediaItem->iAP2MediaItemAlbumDiscCount_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumDiscCount",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber,
                        &theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumDiscNumber",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier,
                        &theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumPersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumTitle,
                        &theiAP2MediaItem->iAP2MediaItemAlbumTitle_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumTitle",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumTrackCount,
                        &theiAP2MediaItem->iAP2MediaItemAlbumTrackCount_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumTrackCount",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber,
                        &theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemAlbumTrackNumber",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemArtist,
                        &theiAP2MediaItem->iAP2MediaItemArtist_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemArtist",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier,
                        &theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemArtistPersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier,
                        &theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemArtworkFileTransferIdentifier",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemChapterCount,
                        &theiAP2MediaItem->iAP2MediaItemChapterCount_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemChapterCount",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemComposer,
                        &theiAP2MediaItem->iAP2MediaItemComposer_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemComposer",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier,
                        &theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemComposerPersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemGenre,
                        &theiAP2MediaItem->iAP2MediaItemGenre_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemGenre",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier,
                        &theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemGenrePersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemIsBanned,
                        &theiAP2MediaItem->iAP2MediaItemIsBanned_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemIsBanned",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemIsBanSupported,
                        &theiAP2MediaItem->iAP2MediaItemIsBanSupported_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemIsBanSupported",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemIsLiked,
                        &theiAP2MediaItem->iAP2MediaItemIsLiked_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemIsLiked",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemIsLikeSupported,
                        &theiAP2MediaItem->iAP2MediaItemIsLikeSupported_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemIsLikeSupported",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation,
                        &theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemIsPartOfCompilation",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice,
                        &theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemIsResidentOnDevice",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemMediaType,
                        &theiAP2MediaItem->iAP2MediaItemMediaType_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemMediaType",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemPersistentIdentifier,
                        &theiAP2MediaItem->iAP2MediaItemPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemPersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds,
                        &theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemPlaybackDurationInMilliseconds",
                        iAP2_msecs32);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemRating,
                        &theiAP2MediaItem->iAP2MediaItemRating_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemRating",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItem->iAP2MediaItemTitle,
                        &theiAP2MediaItem->iAP2MediaItemTitle_count,
                        (S8*)"theiAP2MediaItem->iAP2MediaItemTitle",
                        iAP2_utf8);
}

void iAP2FreeiAP2MediaItemAttributes(iAP2MediaItemAttributes* theiAP2MediaItemAttributes)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemAlbumDiscCount,
                        &theiAP2MediaItemAttributes->iAP2MediaItemAlbumDiscCount_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemAlbumDiscCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemAlbumDiscNumber,
                        &theiAP2MediaItemAttributes->iAP2MediaItemAlbumDiscNumber_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemAlbumDiscNumber",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemAlbumTitle,
                        &theiAP2MediaItemAttributes->iAP2MediaItemAlbumTitle_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemAlbumTitle",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemAlbumTrackCount,
                        &theiAP2MediaItemAttributes->iAP2MediaItemAlbumTrackCount_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemAlbumTrackCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemAlbumTrackNumber,
                        &theiAP2MediaItemAttributes->iAP2MediaItemAlbumTrackNumber_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemAlbumTrackNumber",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemArtist,
                        &theiAP2MediaItemAttributes->iAP2MediaItemArtist_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemArtist",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemArtworkFileTransferIdentifier,
                        &theiAP2MediaItemAttributes->iAP2MediaItemArtworkFileTransferIdentifier_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemArtworkFileTransferIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemChapterCount,
                        &theiAP2MediaItemAttributes->iAP2MediaItemChapterCount_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemChapterCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemComposer,
                        &theiAP2MediaItemAttributes->iAP2MediaItemComposer_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemComposer",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemGenre,
                        &theiAP2MediaItemAttributes->iAP2MediaItemGenre_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemGenre",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemIsBanned,
                        &theiAP2MediaItemAttributes->iAP2MediaItemIsBanned_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemIsBanned",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemIsBanSupported,
                        &theiAP2MediaItemAttributes->iAP2MediaItemIsBanSupported_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemIsBanSupported",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemIsLiked,
                        &theiAP2MediaItemAttributes->iAP2MediaItemIsLiked_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemIsLiked",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemIsLikeSupported,
                        &theiAP2MediaItemAttributes->iAP2MediaItemIsLikeSupported_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemIsLikeSupported",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemPersistentIdentifier,
                        &theiAP2MediaItemAttributes->iAP2MediaItemPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemPlaybackDurationInMilliseconds,
                        &theiAP2MediaItemAttributes->iAP2MediaItemPlaybackDurationInMilliseconds_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemPlaybackDurationInMilliseconds",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemAttributes->iAP2MediaItemTitle,
                        &theiAP2MediaItemAttributes->iAP2MediaItemTitle_count,
                        (S8*)"theiAP2MediaItemAttributes->iAP2MediaItemTitle",
                        iAP2_none);
}

void iAP2FreeiAP2MediaItemProperties(iAP2MediaItemProperties* theiAP2MediaItemProperties)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumArtist,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumArtist_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumArtist",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumArtistPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumDiscCount,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumDiscCount_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumDiscCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumDiscNumber,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumDiscNumber_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumDiscNumber",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumPersistentIdentifier,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTitle,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTitle_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTitle",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackCount,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackCount_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackNumber,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackNumber_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyAlbumTrackNumber",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyArtist,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyArtist_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyArtist",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyArtistPersistentIdentifier,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyArtistPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyArtistPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyChapterCount,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyChapterCount_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyChapterCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyComposer,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyComposer_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyComposer",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyComposerPersistentIdentifier,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyComposerPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyComposerPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyGenre,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyGenre_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyGenre",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyGenrePersistenIdentifier,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyGenrePersistenIdentifier_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyGenrePersistenIdentifier",
                        iAP2_none);
    if(theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanned != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsBanned is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanned,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanned_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanned",
                        iAP2_none);
    if(theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanSupported != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsBanSupported is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanSupported,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanSupported_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyIsBanSupported",
                        iAP2_none);
    if(theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLiked != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsLiked is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLiked,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLiked_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLiked",
                        iAP2_none);
    if(theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLikeSupported != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaItemPropertyIsLikeSupported is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLikeSupported,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLikeSupported_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyIsLikeSupported",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyIsPartOfCompilation,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyIsPartOfCompilation_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyIsPartOfCompilation",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyIsResidentOndevice,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyIsResidentOndevice_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyIsResidentOndevice",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyMediaType,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyMediaType_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyMediaType",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyPersistentIdentifier,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyPersistentIdentifier_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyPlaybackDurationInMilliseconds,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyPlaybackDurationInMilliseconds_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyPlaybackDurationInMilliseconds",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyRating,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyRating_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyRating",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaItemProperties->iAP2MediaItemPropertyTitle,
                        &theiAP2MediaItemProperties->iAP2MediaItemPropertyTitle_count,
                        (S8*)"theiAP2MediaItemProperties->iAP2MediaItemPropertyTitle",
                        iAP2_none);
}

void iAP2FreeiAP2MediaLibraryInformationSubParameter(iAP2MediaLibraryInformationSubParameter* theiAP2MediaLibraryInformationSubParameter)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName,
                        &theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName_count,
                        (S8*)"theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier,
                        &theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier_count,
                        (S8*)"theiAP2MediaLibraryInformationSubParameter->iAP2MediaUniqueIdentifier",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType,
                        &theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType_count,
                        (S8*)"theiAP2MediaLibraryInformationSubParameter->iAP2MediaLibraryType",
                        iAP2_enum);
}

void iAP2FreeiAP2MediaPlayList(iAP2MediaPlayList* theiAP2MediaPlayList)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistContainedMediaItemsFileTransferIdentifier",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistIsAppleMusicRadioStation",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistIsFolder",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistIsGeniusMix",
                        iAP2_bool);
    if(theiAP2MediaPlayList->iAP2MediaPlaylistIsiTunesRadioStation != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaPlaylistIsiTunesRadioStation is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistIsiTunesRadioStation,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistIsiTunesRadioStation_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistIsiTunesRadioStation",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistName,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistName_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistParentPersistentIdentifer",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistPersistentIdentifier",
                        iAP2_uint64);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlayList->iAP2MediaPlaylistContentTransfer,
                        &theiAP2MediaPlayList->iAP2MediaPlaylistContentTransfer_count,
                        (S8*)"theiAP2MediaPlayList->iAP2MediaPlaylistContentTransfer",
                        iAP2_none);
}

void iAP2FreeiAP2MediaPlaylistContentTransferInfoRequest(iAP2MediaPlaylistContentTransferInfoRequest* theiAP2MediaPlaylistContentTransferInfoRequest)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemPlD,
                        &theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemPlD_count,
                        (S8*)"theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemPlD",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemTitle,
                        &theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemTitle_count,
                        (S8*)"theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemTitle",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemAlbumTitle,
                        &theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemAlbumTitle_count,
                        (S8*)"theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemAlbumTitle",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemArtist,
                        &theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemArtist_count,
                        (S8*)"theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemArtist",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemAlbumArtist,
                        &theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemAlbumArtist_count,
                        (S8*)"theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MedialtemAlbumArtist",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemGenre,
                        &theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemGenre_count,
                        (S8*)"theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemGenre",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemComposer,
                        &theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemComposer_count,
                        (S8*)"theiAP2MediaPlaylistContentTransferInfoRequest->iAP2MediaItemComposer",
                        iAP2_none);
}

void iAP2FreeiAP2MediaPlaylistProperties(iAP2MediaPlaylistProperties* theiAP2MediaPlaylistProperties)
{
    if(theiAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItems != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaPlayListContainedMediaItems is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItems,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItems_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItems",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListContainedMediaItemsFileTransferIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsAppleMusicRadioStation,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsAppleMusicRadioStation_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsAppleMusicRadioStation",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsFolder,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsFolder_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsFolder",
                        iAP2_none);
    if(theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsiTunesRadioStation != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2MediaPlayListPropertyIsiTunesRadioStation is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsiTunesRadioStation,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsiTunesRadioStation_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyIsiTunesRadioStation",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyName,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyName_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyName",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyParentPersistentIdentifier,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyParentPersistentIdentifier_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyParentPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPersistentIdentifier,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPersistentIdentifier_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPersistentIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPropertyIsGeniusMix,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPropertyIsGeniusMix_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlayListPropertyPropertyIsGeniusMix",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2MediaPlaylistProperties->iAP2MediaPlaylistContentTransfer,
                        &theiAP2MediaPlaylistProperties->iAP2MediaPlaylistContentTransfer_count,
                        (S8*)"theiAP2MediaPlaylistProperties->iAP2MediaPlaylistContentTransfer",
                        iAP2_none);
}

void iAP2FreeiAP2PlaybackAttributes(iAP2PlaybackAttributes* theiAP2PlaybackAttributes)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd,
                        &theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioAd",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName,
                        &theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PBAppleMusicRadioStationName",
                        iAP2_utf8);
    if(theiAP2PlaybackAttributes->iAP2PBiTunesRadioAd != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesRadioAd is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PBiTunesRadioAd,
                        &theiAP2PlaybackAttributes->iAP2PBiTunesRadioAd_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PBiTunesRadioAd",
                        iAP2_bool);
    if(theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationMediaPlaylistPersistentID != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesRadioStationMediaPlaylistPersistentID is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationMediaPlaylistPersistentID,
                        &theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationMediaPlaylistPersistentID_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationMediaPlaylistPersistentID",
                        iAP2_uint64);
    if(theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationName != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesRadioStationName is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationName,
                        &theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationName_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PBiTunesRadioStationName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier,
                        &theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PBMediaLibraryUniqueIdentifier",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID,
                        &theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackAppBundleID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackAppName,
                        &theiAP2PlaybackAttributes->iAP2PlaybackAppName_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackAppName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds,
                        &theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds",
                        iAP2_msecs32);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex,
                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackQueueChapterIndex",
                        iAP2_uint32);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackQueueCount,
                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueCount_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackQueueCount",
                        iAP2_uint32);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex,
                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackQueueIndex",
                        iAP2_uint32);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail,
                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackQueueListAvail",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID,
                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackQueueListTransferID",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode,
                        &theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackRepeatMode",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode,
                        &theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackShuffleMode",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackSpeed,
                        &theiAP2PlaybackAttributes->iAP2PlaybackSpeed_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackSpeed",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackStatus,
                        &theiAP2PlaybackAttributes->iAP2PlaybackStatus_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackStatus",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable,
                        &theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2SetElapsedTimeAvailable",
                        iAP2_bool);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PlaybackQueueListContentTransfer,
                        &theiAP2PlaybackAttributes->iAP2PlaybackQueueListContentTransfer_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PlaybackQueueListContentTransfer",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID,
                        &theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count,
                        (S8*)"theiAP2PlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID",
                        iAP2_uint64);
}

void iAP2FreeiAP2PlaybackQueueListContentTransferInfoRequest(iAP2PlaybackQueueListContentTransferInfoRequest* theiAP2PlaybackQueueListContentTransferInfoRequest)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemPID,
                        &theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemPID_count,
                        (S8*)"theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemPID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemTitle,
                        &theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemTitle_count,
                        (S8*)"theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemTitle",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemAlbumTitle,
                        &theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemAlbumTitle_count,
                        (S8*)"theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemAlbumTitle",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemArtist,
                        &theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemArtist_count,
                        (S8*)"theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemArtist",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemAlbumArtist,
                        &theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemAlbumArtist_count,
                        (S8*)"theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemAlbumArtist",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemGenre,
                        &theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemGenre_count,
                        (S8*)"theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemGenre",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemComposer,
                        &theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemComposer_count,
                        (S8*)"theiAP2PlaybackQueueListContentTransferInfoRequest->iAP2MediaItemComposer",
                        iAP2_none);
}

void iAP2FreeiAP2RecentsList(iAP2RecentsList* theiAP2RecentsList)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2AddressBookID,
                        &theiAP2RecentsList->iAP2AddressBookID_count,
                        (S8*)"theiAP2RecentsList->iAP2AddressBookID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2DisplayName,
                        &theiAP2RecentsList->iAP2DisplayName_count,
                        (S8*)"theiAP2RecentsList->iAP2DisplayName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2Duration,
                        &theiAP2RecentsList->iAP2Duration_count,
                        (S8*)"theiAP2RecentsList->iAP2Duration",
                        iAP2_secs32);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2Index,
                        &theiAP2RecentsList->iAP2Index_count,
                        (S8*)"theiAP2RecentsList->iAP2Index",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2Label,
                        &theiAP2RecentsList->iAP2Label_count,
                        (S8*)"theiAP2RecentsList->iAP2Label",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2Occurrences,
                        &theiAP2RecentsList->iAP2Occurrences_count,
                        (S8*)"theiAP2RecentsList->iAP2Occurrences",
                        iAP2_uint8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2RemoteID,
                        &theiAP2RecentsList->iAP2RemoteID_count,
                        (S8*)"theiAP2RecentsList->iAP2RemoteID",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2Service,
                        &theiAP2RecentsList->iAP2Service_count,
                        (S8*)"theiAP2RecentsList->iAP2Service",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2Type,
                        &theiAP2RecentsList->iAP2Type_count,
                        (S8*)"theiAP2RecentsList->iAP2Type",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsList->iAP2UnixTimestamp,
                        &theiAP2RecentsList->iAP2UnixTimestamp_count,
                        (S8*)"theiAP2RecentsList->iAP2UnixTimestamp",
                        iAP2_uint64);
}

void iAP2FreeiAP2RecentsListProperties(iAP2RecentsListProperties* theiAP2RecentsListProperties)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2AddressBookID,
                        &theiAP2RecentsListProperties->iAP2AddressBookID_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2AddressBookID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2DisplayName,
                        &theiAP2RecentsListProperties->iAP2DisplayName_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2DisplayName",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2Duration,
                        &theiAP2RecentsListProperties->iAP2Duration_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2Duration",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2Index,
                        &theiAP2RecentsListProperties->iAP2Index_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2Index",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2Label,
                        &theiAP2RecentsListProperties->iAP2Label_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2Label",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2Occurrences,
                        &theiAP2RecentsListProperties->iAP2Occurrences_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2Occurrences",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2RemoteID,
                        &theiAP2RecentsListProperties->iAP2RemoteID_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2RemoteID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2Service,
                        &theiAP2RecentsListProperties->iAP2Service_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2Service",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2Type,
                        &theiAP2RecentsListProperties->iAP2Type_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2Type",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2RecentsListProperties->iAP2UnixTimestamp,
                        &theiAP2RecentsListProperties->iAP2UnixTimestamp_count,
                        (S8*)"theiAP2RecentsListProperties->iAP2UnixTimestamp",
                        iAP2_none);
}

void iAP2FreeiAP2RouteGuidanceDisplayComponent(iAP2RouteGuidanceDisplayComponent* theiAP2RouteGuidanceDisplayComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2RouteGuidanceDisplayComponent->iAP2Identifier,
                        &theiAP2RouteGuidanceDisplayComponent->iAP2Identifier_count,
                        (S8*)"theiAP2RouteGuidanceDisplayComponent->iAP2Identifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2RouteGuidanceDisplayComponent->iAP2Name,
                        &theiAP2RouteGuidanceDisplayComponent->iAP2Name_count,
                        (S8*)"theiAP2RouteGuidanceDisplayComponent->iAP2Name",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2RouteGuidanceDisplayComponent->iAP2MaxCurrentRoadNameLength,
                        &theiAP2RouteGuidanceDisplayComponent->iAP2MaxCurrentRoadNameLength_count,
                        (S8*)"theiAP2RouteGuidanceDisplayComponent->iAP2MaxCurrentRoadNameLength",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2RouteGuidanceDisplayComponent->iAP2MaxDestinationRoadNameLength,
                        &theiAP2RouteGuidanceDisplayComponent->iAP2MaxDestinationRoadNameLength_count,
                        (S8*)"theiAP2RouteGuidanceDisplayComponent->iAP2MaxDestinationRoadNameLength",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2RouteGuidanceDisplayComponent->iAP2MaxAfterManeuverRoadNameLength,
                        &theiAP2RouteGuidanceDisplayComponent->iAP2MaxAfterManeuverRoadNameLength_count,
                        (S8*)"theiAP2RouteGuidanceDisplayComponent->iAP2MaxAfterManeuverRoadNameLength",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2RouteGuidanceDisplayComponent->iAP2MaxManeuverDescriptionLength,
                        &theiAP2RouteGuidanceDisplayComponent->iAP2MaxManeuverDescriptionLength_count,
                        (S8*)"theiAP2RouteGuidanceDisplayComponent->iAP2MaxManeuverDescriptionLength",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2RouteGuidanceDisplayComponent->iAP2MaxGuidanceManeuverStorageCapacity,
                        &theiAP2RouteGuidanceDisplayComponent->iAP2MaxGuidanceManeuverStorageCapacity_count,
                        (S8*)"theiAP2RouteGuidanceDisplayComponent->iAP2MaxGuidanceManeuverStorageCapacity",
                        iAP2_uint16);
}

void iAP2FreeiAP2SerialTransportComponent(iAP2SerialTransportComponent* theiAP2SerialTransportComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2SerialTransportComponent->iAP2TransportComponentIdentifier,
                        &theiAP2SerialTransportComponent->iAP2TransportComponentIdentifier_count,
                        (S8*)"theiAP2SerialTransportComponent->iAP2TransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2SerialTransportComponent->iAP2TransportComponentName,
                        &theiAP2SerialTransportComponent->iAP2TransportComponentName_count,
                        (S8*)"theiAP2SerialTransportComponent->iAP2TransportComponentName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2SerialTransportComponent->iAP2TransportSupportsiAP2Connection,
                        &theiAP2SerialTransportComponent->iAP2TransportSupportsiAP2Connection_count,
                        (S8*)"theiAP2SerialTransportComponent->iAP2TransportSupportsiAP2Connection",
                        iAP2_none);
}

void iAP2FreeiAP2StartNowPlayingPlaybackAttributes(iAP2StartNowPlayingPlaybackAttributes* theiAP2StartNowPlayingPlaybackAttributes)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppeMusicRadioStationMediaPlaylistPersistentID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppleMusicRadioAd,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppleMusicRadioAd_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppleMusicRadioAd",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppleMusicRadioStationName,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppleMusicRadioStationName_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PBAppleMusicRadioStationName",
                        iAP2_none);
    if(theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesRadioAd != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesRadioAd is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesRadioAd,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesRadioAd_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesRadioAd",
                        iAP2_none);
    if(theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationMediaPlaylistPersistentID != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesStationMediaPlaylistPersistentID is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationMediaPlaylistPersistentID,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationMediaPlaylistPersistentID_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationMediaPlaylistPersistentID",
                        iAP2_none);
    if(theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationName != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2PBiTunesStationName is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationName,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationName_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PBiTunesStationName",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackAppBundleID,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackAppBundleID_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackAppBundleID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackAppName,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackAppName_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackAppName",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackElapsedTimeInMilliseconds",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackMediaLibraryUniqueIdentifier,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackMediaLibraryUniqueIdentifier_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackMediaLibraryUniqueIdentifier",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueChapterIndex,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueChapterIndex_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueChapterIndex",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueCount,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueCount_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueCount",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueIndex,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueIndex_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueIndex",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListAvail,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListAvail_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListAvail",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListTransferID,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListTransferID_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListTransferID",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackRepeatMode,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackRepeatMode_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackRepeatMode",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackShuffleMode,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackShuffleMode_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackShuffleMode",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackSpeed,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackSpeed_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackSpeed",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackStatus,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackStatus_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackStatus",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2SetElapsedTimeAvailable,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2SetElapsedTimeAvailable_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2SetElapsedTimeAvailable",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListContentTransferSize,
                        &theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListContentTransferSize_count,
                        (S8*)"theiAP2StartNowPlayingPlaybackAttributes->iAP2PlaybackQueueListContentTransferSize",
                        iAP2_uint32);
}

void iAP2FreeiAP2USBDeviceTransportComponent(iAP2USBDeviceTransportComponent* theiAP2USBDeviceTransportComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2USBDeviceTransportComponent->iAP2TransportComponentIdentifier,
                        &theiAP2USBDeviceTransportComponent->iAP2TransportComponentIdentifier_count,
                        (S8*)"theiAP2USBDeviceTransportComponent->iAP2TransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBDeviceTransportComponent->iAP2TransportComponentName,
                        &theiAP2USBDeviceTransportComponent->iAP2TransportComponentName_count,
                        (S8*)"theiAP2USBDeviceTransportComponent->iAP2TransportComponentName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBDeviceTransportComponent->iAP2TransportSupportsiAP2Connection,
                        &theiAP2USBDeviceTransportComponent->iAP2TransportSupportsiAP2Connection_count,
                        (S8*)"theiAP2USBDeviceTransportComponent->iAP2TransportSupportsiAP2Connection",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBDeviceTransportComponent->iAP2USBDeviceSupportedAudioSampleRate,
                        &theiAP2USBDeviceTransportComponent->iAP2USBDeviceSupportedAudioSampleRate_count,
                        (S8*)"theiAP2USBDeviceTransportComponent->iAP2USBDeviceSupportedAudioSampleRate",
                        iAP2_enum);
}

void iAP2FreeiAP2USBHostHIDComponent(iAP2USBHostHIDComponent* theiAP2USBHostHIDComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostHIDComponent->iAP2HIDComponentFunction,
                        &theiAP2USBHostHIDComponent->iAP2HIDComponentFunction_count,
                        (S8*)"theiAP2USBHostHIDComponent->iAP2HIDComponentFunction",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostHIDComponent->iAP2HIDComponentIdentifier,
                        &theiAP2USBHostHIDComponent->iAP2HIDComponentIdentifier_count,
                        (S8*)"theiAP2USBHostHIDComponent->iAP2HIDComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostHIDComponent->iAP2HIDComponentName,
                        &theiAP2USBHostHIDComponent->iAP2HIDComponentName_count,
                        (S8*)"theiAP2USBHostHIDComponent->iAP2HIDComponentName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostHIDComponent->iAP2USBHostTransportComponentIdentifier,
                        &theiAP2USBHostHIDComponent->iAP2USBHostTransportComponentIdentifier_count,
                        (S8*)"theiAP2USBHostHIDComponent->iAP2USBHostTransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostHIDComponent->iAP2USBHostTransportInterfaceNumber,
                        &theiAP2USBHostHIDComponent->iAP2USBHostTransportInterfaceNumber_count,
                        (S8*)"theiAP2USBHostHIDComponent->iAP2USBHostTransportInterfaceNumber",
                        iAP2_uint16);
}

void iAP2FreeiAP2USBHostTransportComponent(iAP2USBHostTransportComponent* theiAP2USBHostTransportComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostTransportComponent->iAP2TransportComponentIdentifier,
                        &theiAP2USBHostTransportComponent->iAP2TransportComponentIdentifier_count,
                        (S8*)"theiAP2USBHostTransportComponent->iAP2TransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostTransportComponent->iAP2TransportComponentName,
                        &theiAP2USBHostTransportComponent->iAP2TransportComponentName_count,
                        (S8*)"theiAP2USBHostTransportComponent->iAP2TransportComponentName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostTransportComponent->iAP2TransportSupportsCarPlay,
                        &theiAP2USBHostTransportComponent->iAP2TransportSupportsCarPlay_count,
                        (S8*)"theiAP2USBHostTransportComponent->iAP2TransportSupportsCarPlay",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostTransportComponent->iAP2TransportSupportsiAP2Connection,
                        &theiAP2USBHostTransportComponent->iAP2TransportSupportsiAP2Connection_count,
                        (S8*)"theiAP2USBHostTransportComponent->iAP2TransportSupportsiAP2Connection",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2USBHostTransportComponent->iAP2USBHostTransportCarPlaytInterfaceNumber,
                        &theiAP2USBHostTransportComponent->iAP2USBHostTransportCarPlaytInterfaceNumber_count,
                        (S8*)"theiAP2USBHostTransportComponent->iAP2USBHostTransportCarPlaytInterfaceNumber",
                        iAP2_uint8);
}

void iAP2FreeiAP2VehicleInformationComponent(iAP2VehicleInformationComponent* theiAP2VehicleInformationComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleInformationComponent->iAP2DisplayName,
                        &theiAP2VehicleInformationComponent->iAP2DisplayName_count,
                        (S8*)"theiAP2VehicleInformationComponent->iAP2DisplayName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleInformationComponent->iAP2EngineType,
                        &theiAP2VehicleInformationComponent->iAP2EngineType_count,
                        (S8*)"theiAP2VehicleInformationComponent->iAP2EngineType",
                        iAP2_enum);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleInformationComponent->iAP2Identifier,
                        &theiAP2VehicleInformationComponent->iAP2Identifier_count,
                        (S8*)"theiAP2VehicleInformationComponent->iAP2Identifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleInformationComponent->iAP2Name,
                        &theiAP2VehicleInformationComponent->iAP2Name_count,
                        (S8*)"theiAP2VehicleInformationComponent->iAP2Name",
                        iAP2_utf8);
}

void iAP2FreeiAP2VehicleStatusComponent(iAP2VehicleStatusComponent* theiAP2VehicleStatusComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusComponent->iAP2Identifier,
                        &theiAP2VehicleStatusComponent->iAP2Identifier_count,
                        (S8*)"theiAP2VehicleStatusComponent->iAP2Identifier",
                        iAP2_uint16);
    if(theiAP2VehicleStatusComponent->iAP2InsideTemperature != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2InsideTemperature is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusComponent->iAP2InsideTemperature,
                        &theiAP2VehicleStatusComponent->iAP2InsideTemperature_count,
                        (S8*)"theiAP2VehicleStatusComponent->iAP2InsideTemperature",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusComponent->iAP2Name,
                        &theiAP2VehicleStatusComponent->iAP2Name_count,
                        (S8*)"theiAP2VehicleStatusComponent->iAP2Name",
                        iAP2_utf8);
    if(theiAP2VehicleStatusComponent->iAP2NightMode != NULL)
    {
        IAP2SESSIONDLTLOG(DLT_LOG_ERROR, "The Parameter iAP2NightMode is Deprecated, Don't use it. Kindly refer the Apple Specification");
    }
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusComponent->iAP2NightMode,
                        &theiAP2VehicleStatusComponent->iAP2NightMode_count,
                        (S8*)"theiAP2VehicleStatusComponent->iAP2NightMode",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusComponent->iAP2OutsideTemperature,
                        &theiAP2VehicleStatusComponent->iAP2OutsideTemperature_count,
                        (S8*)"theiAP2VehicleStatusComponent->iAP2OutsideTemperature",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusComponent->iAP2Range,
                        &theiAP2VehicleStatusComponent->iAP2Range_count,
                        (S8*)"theiAP2VehicleStatusComponent->iAP2Range",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2VehicleStatusComponent->iAP2RangeWarning,
                        &theiAP2VehicleStatusComponent->iAP2RangeWarning_count,
                        (S8*)"theiAP2VehicleStatusComponent->iAP2RangeWarning",
                        iAP2_none);
}

void iAP2FreeiAP2WirelessCarPlayTransportComponent(iAP2WirelessCarPlayTransportComponent* theiAP2WirelessCarPlayTransportComponent)
{
    iAP2FreeiAP2Pointer((void**)&theiAP2WirelessCarPlayTransportComponent->iAP2TransportComponentIdentifier,
                        &theiAP2WirelessCarPlayTransportComponent->iAP2TransportComponentIdentifier_count,
                        (S8*)"theiAP2WirelessCarPlayTransportComponent->iAP2TransportComponentIdentifier",
                        iAP2_uint16);
    iAP2FreeiAP2Pointer((void**)&theiAP2WirelessCarPlayTransportComponent->iAP2TransportComponentName,
                        &theiAP2WirelessCarPlayTransportComponent->iAP2TransportComponentName_count,
                        (S8*)"theiAP2WirelessCarPlayTransportComponent->iAP2TransportComponentName",
                        iAP2_utf8);
    iAP2FreeiAP2Pointer((void**)&theiAP2WirelessCarPlayTransportComponent->iAP2TransportSupportsCarPlay,
                        &theiAP2WirelessCarPlayTransportComponent->iAP2TransportSupportsCarPlay_count,
                        (S8*)"theiAP2WirelessCarPlayTransportComponent->iAP2TransportSupportsCarPlay",
                        iAP2_none);
    iAP2FreeiAP2Pointer((void**)&theiAP2WirelessCarPlayTransportComponent->iAP2TransportSupportsiAP2Connection,
                        &theiAP2WirelessCarPlayTransportComponent->iAP2TransportSupportsiAP2Connection_count,
                        (S8*)"theiAP2WirelessCarPlayTransportComponent->iAP2TransportSupportsiAP2Connection",
                        iAP2_none);
}
